/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE_TIME;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.FILE;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.INTEGER;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.NUMBER;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.STRING;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.FromJsonInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.JsonInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.StringInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.BooleanInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.DateOnlyInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.DateTimeInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.FileInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.IntegerInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.NumberInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.TimeOnlyInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.XmlInputMetadataResolver;

import java.nio.file.Path;

public class SdkInputMetadataResolver extends SdkAbstractStaticMetadataResolver {

  private String qName;

  public SdkInputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector,
                                  ConnectorOperation operation, TypeDefinition typeDefinition,
                                  FileGenerationUtils.SchemaNameType schemaNameType,
                                  String partName)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName);
  }

  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
    TypeSchema typeSchema = typeDefinition.getTypeSchema();

    if (typeDefinition instanceof PrimitiveTypeDefinition) {
      return getPrimitiveMetadataResolverClass((PrimitiveTypeDefinition) typeDefinition);
    } else if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(APPLICATION_XML_TYPE)) {
      qName = ((XmlTypeSchema) typeDefinition.getTypeSchema()).getElementName();
      return XmlInputMetadataResolver.class;
    } else if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(APPLICATION_JSON_TYPE)) {
      return JsonInputMetadataResolver.class;
    } else if (typeSchema instanceof CustomTypeSchema) {
      return FromJsonInputMetadataResolver.class;
    }

    return StringInputMetadataResolver.class;
  }

  protected Class<?> getPrimitiveMetadataResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition)
      throws TemplatingException {
    PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();

    if (primitiveType.equals(NUMBER)) {
      return NumberInputMetadataResolver.class;
    }

    if (primitiveType.equals(INTEGER)) {
      return IntegerInputMetadataResolver.class;
    }

    if (primitiveType.equals(STRING)) {
      return StringInputMetadataResolver.class;
    }

    if (primitiveType.equals(BOOLEAN)) {
      return BooleanInputMetadataResolver.class;
    }

    if (primitiveType.equals(DATE_TIME)
        || primitiveType.equals(DATE_TIME_ONLY)) {
      return DateTimeInputMetadataResolver.class;
    }

    if (primitiveType.equals(TIME_ONLY)) {
      return TimeOnlyInputMetadataResolver.class;
    }

    if (primitiveType.equals(DATE_ONLY)
        || primitiveType.equals(DATE)) {
      return DateOnlyInputMetadataResolver.class;
    }

    if (primitiveType.equals(FILE)) {
      return FileInputMetadataResolver.class;
    }

    throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
  }

  @Override
  protected String getClassNameSuffix() {
    return "InputMetadataResolver";
  }

  @Override
  protected boolean requiresQNameMethod() {
    return superclass.equals(XmlInputMetadataResolver.class);
  }

  @Override
  protected boolean requiresFormatMethod() {
    return superclass.equals(FromJsonInputMetadataResolver.class)
        || superclass.equals(FileInputMetadataResolver.class);
  }

  @Override
  protected String getQName() {
    return qName;
  }

  @Override
  protected boolean requiresToWriteSchema() {
    return superclass.equals(FromJsonInputMetadataResolver.class)
        || superclass.equals(JsonInputMetadataResolver.class)
        || superclass.equals(XmlInputMetadataResolver.class);
  }
}
