/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf.security;

import org.mule.connectivity.restconnect.internal.webapi.parser.security.OAS2SecuritySchemes;
import org.mule.connectivity.restconnect.internal.webapi.parser.security.RAMLSecuritySchemes;

import java.util.Arrays;

public class AMFSecuritySchemesNaming {

  private AMFSecuritySchemesNaming() {}

  public static boolean isOauth1(String name) {
    return RAMLSecuritySchemes.OAUTH1.equalsIgnoreCase(name);
  }

  public static boolean isOauth2(String name) {
    return OAS2SecuritySchemes.OAUTH2.equalsIgnoreCase(name) || RAMLSecuritySchemes.OAUTH2.equalsIgnoreCase(name);
  }

  public static boolean isPassThrough(String name) {
    return RAMLSecuritySchemes.PASS_THROUGH.equalsIgnoreCase(name);
  }

  public static boolean isApiKey(String name) {
    return Arrays.stream(OAS2SecuritySchemes.API_KEY).anyMatch(x -> x.equalsIgnoreCase(name));
  }

  public static boolean isBasicAuth(String name) {
    return OAS2SecuritySchemes.BASIC.equalsIgnoreCase(name) || RAMLSecuritySchemes.BASIC.equalsIgnoreCase(name);
  }

  public static boolean isDigest(String name) {
    return RAMLSecuritySchemes.DIGEST_AUTHENTICATION.equalsIgnoreCase(name);
  }

  public static boolean isCustom(String name) {
    return name.toLowerCase().startsWith("x-");
  }

}
