/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;
import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;
import static org.apache.commons.lang.StringUtils.isNotBlank;

import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;

import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;

import javax.ws.rs.core.MediaType;

public class RPTypeSchemaModel extends APITypeSchemaModel {

  public RPTypeSchemaModel(TypeDeclaration typeDeclaration, MediaType mediaType) {
    this.typeSchema = buildTypeSchema(typeDeclaration, mediaType);
  }

  private TypeSchema buildTypeSchema(TypeDeclaration typeDeclaration, MediaType mediaType) {

    TypeSchema newTypeSchema;

    if (isXmlTypeDeclaration(typeDeclaration)) {
      newTypeSchema = buildXmlTypeSchema((XMLTypeDeclaration) typeDeclaration);
    }

    else if (isJsonTypeDeclaration(typeDeclaration)) {
      if (mediaType.isCompatible(APPLICATION_JSON_TYPE)) {
        newTypeSchema = new JsonTypeSchema(((JSONTypeDeclaration) typeDeclaration).schemaContent());
      } else {
        newTypeSchema = new CustomTypeSchema(((JSONTypeDeclaration) typeDeclaration)::schemaContent, mediaType);
      }
    }

    else if (APPLICATION_JSON_TYPE.isCompatible(mediaType)) {
      newTypeSchema = new JsonTypeSchema(new RPTypeSchemaSupplier(typeDeclaration, APPLICATION_JSON_TYPE));
    }

    else if (MediaType.APPLICATION_XML_TYPE.isCompatible(mediaType)) {
      newTypeSchema = new XmlTypeSchema(new RPTypeSchemaSupplier(typeDeclaration, APPLICATION_XML_TYPE));
    }

    else {
      newTypeSchema = new CustomTypeSchema(new RPTypeSchemaSupplier(typeDeclaration, mediaType), mediaType);
    }

    return newTypeSchema;
  }

  private boolean isXmlTypeDeclaration(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof XMLTypeDeclaration;
  }

  private boolean isJsonTypeDeclaration(TypeDeclaration typeDeclaration) {
    return typeDeclaration instanceof JSONTypeDeclaration;
  }

  private static TypeSchema buildXmlTypeSchema(XMLTypeDeclaration xmlTypeDeclaration) {
    String elementName =
        isNotBlank(xmlTypeDeclaration.internalFragment()) ? xmlTypeDeclaration.internalFragment() : null;
    String path = xmlTypeDeclaration.schemaPath();

    return new XmlTypeSchema(xmlTypeDeclaration.schemaContent(), elementName, path);
  }
}
