/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.mule.connectivity.restconnect.internal.descriptor.model.TestConnectionResponseValidationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorExpressionParser;

public class DescriptorTestConnectionResponseValidationParser {
    private static final String RESPONSE_VALIDATION = "http://a.ml/vocabularies/restConnect#testConnectionResponseValidation";
    private static final String VALIDATION_EXPRESSION = "http://a.ml/vocabularies/restConnect#testConnectionValidationExpression";
    private static final String ERROR_TEMPLATE_EXPRESSION = "http://a.ml/vocabularies/restConnect#testConnectionErrorTemplate";
    DescriptorExpressionParser descriptorExpressionParser = new DescriptorExpressionParser();

    public List<TestConnectionResponseValidationDescriptor> parseResponseValidations(DialectDomainElement testConnectionElement) {
        return this.getResponseValidationElements(testConnectionElement).stream().map(this::parseResponseValidation).collect(Collectors.toList());
    }

    private TestConnectionResponseValidationDescriptor parseResponseValidation(DialectDomainElement responseValidationElement) {
        if (responseValidationElement == null) {
            return null;
        }
        return new TestConnectionResponseValidationDescriptor(this.descriptorExpressionParser.parseExpression(this.getValidationExpressionElement(responseValidationElement)), this.descriptorExpressionParser.parseExpression(this.getErrorExpressionElement(responseValidationElement)));
    }

    private List<DialectDomainElement> getResponseValidationElements(@NotNull DialectDomainElement testConnectionElement) {
        return testConnectionElement.getObjectPropertyUri(RESPONSE_VALIDATION);
    }

    private DialectDomainElement getValidationExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
        List elements = responseValidationElement.getObjectPropertyUri(VALIDATION_EXPRESSION);
        return elements.isEmpty() ? null : (DialectDomainElement)elements.get(0);
    }

    private DialectDomainElement getErrorExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
        List elements = responseValidationElement.getObjectPropertyUri(ERROR_TEMPLATE_EXPRESSION);
        return elements.isEmpty() ? null : (DialectDomainElement)elements.get(0);
    }
}

