/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkAbstractStaticMetadataResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.BooleanInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.DateOnlyInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.DateTimeInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.FileInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.FromJsonInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.IntegerInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.JsonInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.NumberInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.StringInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.TimeOnlyInputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.input.XmlInputMetadataResolver;

public class SdkInputMetadataResolver
extends SdkAbstractStaticMetadataResolver {
    private String qName;

    public SdkInputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition, FileGenerationUtils.SchemaNameType schemaNameType, String partName) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, schemaNameType, partName);
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
        TypeSchema typeSchema = typeDefinition.getTypeSchema();
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getPrimitiveMetadataResolverClass((PrimitiveTypeDefinition)typeDefinition);
        }
        if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return XmlInputMetadataResolver.class;
        }
        if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return JsonInputMetadataResolver.class;
        }
        if (typeSchema instanceof CustomTypeSchema) {
            return FromJsonInputMetadataResolver.class;
        }
        return StringInputMetadataResolver.class;
    }

    protected Class<?> getPrimitiveMetadataResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition) throws TemplatingException {
        PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
            return NumberInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
            return IntegerInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.STRING)) {
            return StringInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
            return BooleanInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY)) {
            return DateTimeInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
            return TimeOnlyInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE)) {
            return DateOnlyInputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.FILE)) {
            return FileInputMetadataResolver.class;
        }
        throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
    }

    @Override
    protected String getClassNameSuffix() {
        return "InputMetadataResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlInputMetadataResolver.class);
    }

    @Override
    protected boolean requiresFormatMethod() {
        return this.superclass.equals(FromJsonInputMetadataResolver.class) || this.superclass.equals(FileInputMetadataResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean requiresToWriteSchema() {
        return this.superclass.equals(FromJsonInputMetadataResolver.class) || this.superclass.equals(JsonInputMetadataResolver.class) || this.superclass.equals(XmlInputMetadataResolver.class);
    }
}

