/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

public class DescriptorRedundantOutputDefinitionRule
extends PreValidationRule {
    public DescriptorRedundantOutputDefinitionRule() {
        super("Operation descriptor's properties skipOutputTypeValidation, voidOperation and outputType are mutually exclusive.", "", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> allValidationResults = new LinkedList<ValidationResult>();
        for (EndPointDescriptor endpoint : connectorDescriptor.getEndpoints()) {
            List validationResults = endpoint.getOperations().stream().filter(this::moreThanOneExclusiveProperty).map(operation -> this.getValidationError(endpoint.getPath(), operation.getMethod())).collect(Collectors.toList());
            allValidationResults.addAll(validationResults);
        }
        return allValidationResults;
    }

    private boolean moreThanOneExclusiveProperty(OperationDescriptor operationDescriptor) {
        int count = 0;
        if (operationDescriptor.getVoidOperation() != null && operationDescriptor.getVoidOperation().booleanValue()) {
            ++count;
        }
        if (operationDescriptor.getSkipOutputTypeValidation() != null && operationDescriptor.getSkipOutputTypeValidation().booleanValue()) {
            ++count;
        }
        if (StringUtils.isNotBlank((CharSequence)operationDescriptor.getOutputTypeSchema())) {
            ++count;
        }
        return count > 1;
    }

    private ValidationResult getValidationError(String path, String method) {
        String location = "Operation with PATH: " + path + " and METHOD: " + method + " defined in the Connector Descriptor";
        return new ValidationResult(this, location);
    }
}

