/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.ParameterType;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ArrayTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.ObjectTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.UnionTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPPrimitiveTypeModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPTypeSchemaModel;
import org.raml.v2.api.model.v10.datamodel.ArrayTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.JSONTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NullTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.ObjectTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.UnionTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.XMLTypeDeclaration;

public class RPTypeModel
extends APITypeModel {
    private final TypeDeclaration typeDeclaration;

    public RPTypeModel(TypeDeclaration typeDeclaration, String mediaType) {
        this.typeDeclaration = typeDeclaration;
        this.example = this.buildExample();
        this.enumValues = this.buildEnumValues();
        this.mediaType = this.getMediaTypeForStringOrNull(mediaType);
        this.APITypeSchemaModel = new RPTypeSchemaModel(typeDeclaration, this.mediaType);
        this.typeDefinitionClass = this.buildTypeDefinitionClass(this.mediaType);
    }

    private Class<? extends TypeDefinition> buildTypeDefinitionClass(MediaType mediaType) {
        if (MediaType.MULTIPART_FORM_DATA_TYPE.equals((Object)mediaType) && this.typeDeclaration instanceof ObjectTypeDeclaration) {
            return MultipartTypeDefinition.class;
        }
        if (this.typeDeclaration instanceof ObjectTypeDeclaration || this.typeDeclaration instanceof XMLTypeDeclaration || this.typeDeclaration instanceof JSONTypeDeclaration) {
            return ObjectTypeDefinition.class;
        }
        if (this.typeDeclaration instanceof ArrayTypeDeclaration) {
            return ArrayTypeDefinition.class;
        }
        if (this.typeDeclaration instanceof UnionTypeDeclaration) {
            return UnionTypeDefinition.class;
        }
        if (RPTypeModel.typeIsPrimitive(this.typeDeclaration)) {
            this.primitiveTypeModel = new RPPrimitiveTypeModel(this.typeDeclaration);
            return PrimitiveTypeDefinition.class;
        }
        if (this.typeDeclaration instanceof NullTypeDeclaration) {
            return null;
        }
        return EmptyTypeDefinition.class;
    }

    private List<String> buildEnumValues() {
        List enumValues = null;
        if (this.typeDeclaration instanceof StringTypeDeclaration) {
            enumValues = ((StringTypeDeclaration)this.typeDeclaration).enumValues();
        }
        return enumValues;
    }

    private String buildExample() {
        return this.typeDeclaration.example() == null ? null : this.typeDeclaration.example().value();
    }

    private static boolean typeIsPrimitive(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof BooleanTypeDeclaration || typeDeclaration instanceof DateTimeOnlyTypeDeclaration || typeDeclaration instanceof DateTypeDeclaration || typeDeclaration instanceof DateTimeTypeDeclaration || typeDeclaration instanceof FileTypeDeclaration || typeDeclaration instanceof NumberTypeDeclaration || typeDeclaration instanceof StringTypeDeclaration || typeDeclaration instanceof TimeOnlyTypeDeclaration;
    }

    @Override
    public List<APIParameterModel> getParts() {
        if (this.typeDefinitionClass.equals(MultipartTypeDefinition.class)) {
            ArrayList<APIParameterModel> parts = new ArrayList<APIParameterModel>();
            for (TypeDeclaration td : ((ObjectTypeDeclaration)this.typeDeclaration).properties()) {
                parts.add(new RPParameterModel(td, ParameterType.PART, false));
            }
            return parts;
        }
        return Collections.emptyList();
    }

    @Override
    public APITypeModel getInnerType() {
        if (this.typeDeclaration instanceof ArrayTypeDeclaration) {
            return new RPTypeModel(((ArrayTypeDeclaration)this.typeDeclaration).items(), null);
        }
        return null;
    }

    @Override
    public List<APITypeModel> getUnionTypes() {
        if (this.typeDeclaration instanceof UnionTypeDeclaration) {
            ArrayList<APITypeModel> innerTypes = new ArrayList<APITypeModel>();
            for (TypeDeclaration td : ((UnionTypeDeclaration)this.typeDeclaration).of()) {
                innerTypes.add(new RPTypeModel(td, null));
            }
            return innerTypes;
        }
        return Collections.emptyList();
    }
}

