/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.api;

import static org.mule.connectivity.restconnect.internal.templating.TemplateEntity.getTemplateEngine;
import static org.mule.connectivity.restconnect.internal.webapi.parser.ApiParser.parseModel;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.builder.ConnectorModelBuilder;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParser;
import org.mule.connectivity.restconnect.internal.util.AMFWrapper;
import org.mule.connectivity.restconnect.internal.validation.ValidationEngine;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.io.File;
import java.nio.file.Path;

public class RestConnect {

  private RestConnect() {}

  public static ConnectorModel getConnectorModel(File descriptor, File spec, SpecFormat format, Parser parser, String rootDir,
                                                 boolean skipValidations)
      throws ModelGenerationException {
    AMFWrapper.initialize();

    ValidationEngine validationEngine = new ValidationEngine();

    DescriptorParser descriptorParser = new DescriptorParser();
    ConnectorDescriptor connectorDescriptor = descriptorParser.parseConnectorDescriptor(descriptor);

    APIModel apiModel = parseModel(spec, format, parser, rootDir, skipValidations);

    boolean preValidationSuccess = validationEngine.preValidate(connectorDescriptor, apiModel);

    try {
      ConnectorModelBuilder connectorModelBuilder = new ConnectorModelBuilder();
      ConnectorModel connectorModel = connectorModelBuilder.buildConnectorModel(apiModel, connectorDescriptor);

      if (preValidationSuccess && validationEngine.postValidate(connectorModel)) {
        return connectorModel;
      } else {
        throw new ModelGenerationException("There are validation errors");
      }
    } catch (Exception e) {
      if (preValidationSuccess) {
        throw e;
      } else {
        throw new ModelGenerationException("There are validation errors");
      }
    }
  }

  public static void generateConnector(ConnectorModel connectorModel, ConnectorType connectorType, Path outputDir,
                                       Path descriptorPath)
      throws TemplatingException {
    getTemplateEngine(connectorType, connectorModel, outputDir, descriptorPath).applyTemplates();
  }
}
