/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

import static org.mule.connectivity.restconnect.internal.util.JavaUtils.removeJavaNameUnwantedCharacters;
import static org.mule.connectivity.restconnect.internal.util.JavaUtils.removeJavaPackageUnwantedCharacters;

/**
 * This class consists exclusively of static method that return the default package for the connector
 *
 * @author Marcelo Vlaicevich
 *
 */
public final class ConnectorPackage {

  private ConnectorPackage() {}

  /**
   * This method is used to build the base package by default
   *
   * @param connectorName This is the connector name used to create the default package.
   * @return String This returns the base package.
   */
  public static String buildBasePackage(String connectorName) {
    return removeJavaPackageUnwantedCharacters("com.mulesoft.connectors") + "."
        + removeJavaNameUnwantedCharacters(connectorName).toLowerCase();
  }


}
