/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel;

public enum HTTPMethod {

  GET, POST, PUT, PATCH, DELETE, OPTIONS, HEAD;


  public String getVerbName() {
    switch (this) {
      case GET:
        return "GET";
      case POST:
        return "CREATE";
      case PUT:
        return "UPDATE";
      case PATCH:
        return "PATCH";
      case DELETE:
        return "DELETE";
      case OPTIONS:
        return "GET_OPTIONS";
      case HEAD:
        return "GET_HEAD";
    }

    throw new IllegalArgumentException("Unsupported method.");
  }

  public static HTTPMethod fromString(String method) {
    for (HTTPMethod httpMethod : HTTPMethod.values()) {
      if (method.equalsIgnoreCase(httpMethod.name())) {
        return httpMethod;
      }
    }

    throw new IllegalArgumentException("Action '" + method
        + "' should be a get / post / put / patch / delete / options / head operation.");
  }

}
