/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.builder;

import static org.apache.commons.lang.StringUtils.isNotBlank;
import static org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils.isXmlSchema;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.webapi.model.APITypeSchemaModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.TypeSchemaPool;

public class ConnectorTypeSchemaBuilder {

  private TypeSchemaPool typeSchemaPool;

  public ConnectorTypeSchemaBuilder(TypeSchemaPool typeSchemaPool) {
    this.typeSchemaPool = typeSchemaPool;
  }

  public TypeSchema buildTypeSchema(APITypeSchemaModel apiTypeSchemaModel) throws ModelGenerationException {
    if (apiTypeSchemaModel == null) {
      return null;
    }

    return getUniqueTypeSchema(apiTypeSchemaModel.getTypeSchema());
  }

  public TypeSchema buildTypeSchema(String rawSchema) throws ModelGenerationException {
    if (isXmlSchema(rawSchema)) {
      return getUniqueTypeSchema(new XmlTypeSchema(rawSchema));
    } else {
      return getUniqueTypeSchema(new JsonTypeSchema(rawSchema));
    }
  }

  private TypeSchema getUniqueTypeSchema(TypeSchema typeSchema) throws ModelGenerationException {
    if (typeSchema != null && isNotBlank(typeSchema.getRawSchema())) {

      if (typeSchemaPool.containsTypeSchema(typeSchema.getRawSchema())) {
        return typeSchemaPool.getTypeSchema(typeSchema.getRawSchema());
      } else {
        typeSchemaPool.putTypeSchema(typeSchema.getRawSchema(), typeSchema);
      }
    }

    return typeSchema;
  }
}
