/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.type.schema;

import org.apache.ws.commons.schema.XmlSchemaCollection;

import java.io.StringReader;
import java.util.function.Supplier;

public class XmlTypeSchema extends TypeSchema {

  private String elementName;
  private String schemaPath;

  public XmlTypeSchema(Supplier<String> rawSchemaSupplier) {
    super(rawSchemaSupplier);
  }

  public XmlTypeSchema(String rawSchema) {
    super(rawSchema);
  }

  public XmlTypeSchema(String rawSchema, String elementName, String schemaPath) {
    super(rawSchema);
    this.elementName = elementName;
    this.schemaPath = schemaPath;
  }

  public String getSchemaPath() {
    return this.schemaPath;
  }

  public String getElementName() {
    if (elementName == null) {
      elementName = getDefaultElementName();
    }

    return elementName;
  }

  private String getDefaultElementName() {
    XmlSchemaCollection schemaCol = new XmlSchemaCollection();
    org.apache.ws.commons.schema.XmlSchema schema = schemaCol.read(new StringReader(getRawSchema()));
    return schema.getElements().keySet().isEmpty() ? null : schema.getElements().keySet().toArray()[0].toString();
  }

}
