/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.model;

import java.util.List;

public class EndPointDescriptor extends DescriptorElement {

  private String path;
  private List<OperationDescriptor> operations;
  private boolean ignored;
  private String baseUri;
  private String security;

  public EndPointDescriptor(String path, List<OperationDescriptor> operations, boolean ignored, String alternativeBaseUri) {
    this.path = path;
    this.operations = operations;
    this.ignored = ignored;
    this.baseUri = alternativeBaseUri;
  }

  public String getPath() {
    return path;
  }

  public List<OperationDescriptor> getOperations() {
    return operations;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public String getBaseUri() {
    return baseUri;
  }

  public String getSecurity() {
    return security;
  }
}
