/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.model;

import java.util.List;

public class SecuritySchemeDescriptor extends DescriptorElement {

  private String name;
  private List<ParameterDescriptor> headers;
  private List<ParameterDescriptor> queryParameters;
  private boolean ignored;
  private TestConnectionDescriptor testConnection;

  public SecuritySchemeDescriptor(String name,
                                  List<ParameterDescriptor> headers,
                                  List<ParameterDescriptor> queryParameters,
                                  boolean ignored,
                                  TestConnectionDescriptor testConnection) {
    this.name = name;
    this.headers = headers;
    this.queryParameters = queryParameters;
    this.ignored = ignored;
    this.testConnection = testConnection;
  }

  public String getDisplayName() {
    return name;
  }

  public List<ParameterDescriptor> getHeaders() {
    return headers;
  }

  public List<ParameterDescriptor> getQueryParameters() {
    return queryParameters;
  }

  public boolean isIgnored() {
    return ignored;
  }

  public TestConnectionDescriptor getTestConnection() {
    return testConnection;
  }
}
