/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import org.mule.connectivity.restconnect.internal.descriptor.model.ExpressionDescriptor;

import java.util.List;

import javax.validation.constraints.NotNull;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorExpressionParser {

  private static final String REST_CONNECT_EXPRESSION_LANGUAGE = "http://a.ml/vocabularies/restConnect#expressionLanguage";
  private static final String REST_CONNECT_EXPRESSION_CONTENT = "http://a.ml/vocabularies/restConnect#expressionContent";

  public ExpressionDescriptor parseExpression(DialectDomainElement expressionElement) {
    if (expressionElement == null) {
      return null;
    }

    return new ExpressionDescriptor(getLanguage(expressionElement),
                                    getContent(expressionElement));
  }

  private static String getLanguage(@NotNull DialectDomainElement expressionElement) {
    List<Object> expressionLanguage = expressionElement.getScalarByPropertyUri(REST_CONNECT_EXPRESSION_LANGUAGE);

    return expressionLanguage.isEmpty() ? null : expressionLanguage.get(0).toString();
  }

  private static String getContent(@NotNull DialectDomainElement expressionElement) {
    List<Object> expressionContent = expressionElement.getScalarByPropertyUri(REST_CONNECT_EXPRESSION_CONTENT);

    return expressionContent.isEmpty() ? null : expressionContent.get(0).toString();
  }
}
