/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import org.mule.connectivity.restconnect.internal.descriptor.model.MavenGavDescriptor;

import java.util.List;

public class DescriptorMavenGavParser {

  private final static String REST_CONNECT_CONNECTOR_GAV = "http://a.ml/vocabularies/restConnect#connectorGav";
  private final static String ANYPOINT_TENANT_ID = "http://anypoint.com/vocabs/anypoint#tenantId";
  private final static String DIGITAL_REPOSITORY_ARTIFACT_ID = "http://anypoint.com/vocabs/digital-repository#assetId";
  private final static String SCHEMA_ORG_VERSION = "http://anypoint.com/vocabs/schema-org#version";

  public MavenGavDescriptor parseMavenGav(DialectDomainElement mavenGavElement) {
    if (mavenGavElement == null) {
      return null;
    }

    return new MavenGavDescriptor(
                                  parseGroupId(mavenGavElement),
                                  parseArtifactId(mavenGavElement),
                                  parseVersion(mavenGavElement));
  }

  public DialectDomainElement parseConnectorGavElement(DialectDomainElement encodes) {
    List<DialectDomainElement> mavenGavElements = encodes.getObjectPropertyUri(REST_CONNECT_CONNECTOR_GAV);
    return mavenGavElements.isEmpty() ? null : mavenGavElements.get(0);
  }

  private String parseGroupId(DialectDomainElement mavenGavElement) {
    List<Object> groupIds = mavenGavElement.getScalarByPropertyUri(ANYPOINT_TENANT_ID);
    return groupIds.isEmpty() ? null : groupIds.get(0).toString();
  }

  private String parseArtifactId(DialectDomainElement mavenGavElement) {
    List<Object> artifactIds = mavenGavElement.getScalarByPropertyUri(DIGITAL_REPOSITORY_ARTIFACT_ID);
    return artifactIds.isEmpty() ? null : artifactIds.get(0).toString();
  }

  private String parseVersion(DialectDomainElement mavenGavElement) {
    List<Object> versions = mavenGavElement.getScalarByPropertyUri(SCHEMA_ORG_VERSION);
    return versions.isEmpty() ? null : versions.get(0).toString();
  }

}
