/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import static java.util.stream.Collectors.toList;
import org.mule.connectivity.restconnect.internal.descriptor.model.TestConnectionResponseValidationDescriptor;

import java.util.List;

import javax.validation.constraints.NotNull;

import amf.client.model.domain.DialectDomainElement;

public class DescriptorTestConnectionResponseValidationParser {

  private static final String RESPONSE_VALIDATION = "http://a.ml/vocabularies/restConnect#testConnectionResponseValidation";

  private static final String VALIDATION_EXPRESSION = "http://a.ml/vocabularies/restConnect#testConnectionValidationExpression";
  private static final String ERROR_TEMPLATE_EXPRESSION = "http://a.ml/vocabularies/restConnect#testConnectionErrorTemplate";

  DescriptorExpressionParser descriptorExpressionParser = new DescriptorExpressionParser();

  public List<TestConnectionResponseValidationDescriptor> parseResponseValidations(DialectDomainElement testConnectionElement) {
    return getResponseValidationElements(testConnectionElement).stream()
        .map(this::parseResponseValidation)
        .collect(toList());
  }

  private TestConnectionResponseValidationDescriptor parseResponseValidation(DialectDomainElement responseValidationElement) {
    if (responseValidationElement == null) {
      return null;
    }

    return new TestConnectionResponseValidationDescriptor(
                                                          descriptorExpressionParser
                                                              .parseExpression(getValidationExpressionElement(responseValidationElement)),
                                                          descriptorExpressionParser
                                                              .parseExpression(getErrorExpressionElement(responseValidationElement)));
  }

  private List<DialectDomainElement> getResponseValidationElements(@NotNull DialectDomainElement testConnectionElement) {
    return testConnectionElement.getObjectPropertyUri(RESPONSE_VALIDATION);
  }

  private DialectDomainElement getValidationExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
    List<DialectDomainElement> elements = responseValidationElement.getObjectPropertyUri(VALIDATION_EXPRESSION);
    return elements.isEmpty() ? null : elements.get(0);
  }

  private DialectDomainElement getErrorExpressionElement(@NotNull DialectDomainElement responseValidationElement) {
    List<DialectDomainElement> elements = responseValidationElement.getObjectPropertyUri(ERROR_TEMPLATE_EXPRESSION);
    return elements.isEmpty() ? null : elements.get(0);
  }
}
