/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating;

import static org.mule.connectivity.restconnect.api.ConnectorType.SDK_CONNECTOR;
import org.mule.connectivity.restconnect.api.ConnectorType;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;

import java.nio.file.Path;

public abstract class TemplateEntity {

  public static TemplateEntity getTemplateEngine(ConnectorType connectorType, ConnectorModel model, Path outputDir,
                                                 Path descriptorPath)
      throws TemplatingException {
    if (connectorType.equals(SDK_CONNECTOR)) {
      return new SdkConnectorTemplateEntity(outputDir, model, descriptorPath);
    }

    throw new IllegalArgumentException("Connector type not supported");
  }

  public abstract void applyTemplates() throws TemplatingException;
}
