/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.templating.VelocityTemplateEntity;

import java.nio.file.Path;

import static org.mule.connectivity.restconnect.internal.util.JavaUtils.getJavaUpperCamelNameFromXml;

public class SdkMtfOperationTest extends VelocityTemplateEntity {

  private final static String OPERATION_TEST_VM = "templates/sdk/operationMtfTest.vm";
  private ConnectorOperation connectorOperation;

  public SdkMtfOperationTest(ConnectorOperation operation, Path outputDir) {
    super(outputDir);
    connectorOperation = operation;
  }

  public String getTestName() {
    return getJavaUpperCamelNameFromXml(connectorOperation.getInternalName()) + "OperationTest.xml";
  }

  @Override
  public void applyTemplates() throws TemplatingException {
    applyTemplate(OPERATION_TEST_VM, outputDir.resolve("src/test/munit/" + getTestName()));
  }
}
