/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.PagingJsonMetadataResolver;

import java.nio.file.Path;

public class SdkPagingMetadataResolver extends SdkOutputMetadataResolver {

  public SdkPagingMetadataResolver(Path outputDir,
                                   ConnectorModel connectorModel,
                                   SdkConnector sdkConnector,
                                   ConnectorOperation operation,
                                   TypeDefinition typeDefinition)
      throws TemplatingException {
    super(outputDir, connectorModel, sdkConnector, operation, typeDefinition);
  }

  @Override
  protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
    TypeSchema typeSchema = typeDefinition.getTypeSchema();

    if (typeSchema instanceof JsonTypeSchema || typeSchema instanceof CustomTypeSchema) {
      return PagingJsonMetadataResolver.class;
    }

    throw new TemplatingException("TypeSchema not supported as PagingMetadataResolver (Only Json Schemas are supported)");
  }

  @Override
  protected boolean requiresCategoryNameMethod() {
    return false;
  }

  @Override
  protected String getClassNameSuffix() {
    return "PagingMetadataResolver";
  }

  @Override
  protected boolean requiresToWriteSchema() {
    return true;
  }
}
