/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.util;

import static java.util.regex.Pattern.compile;
import static org.mule.connectivity.restconnect.internal.webapi.util.ParserUtils.splitCaps;

import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

public final class NamingUtil {

  private NamingUtil() {}

  private static Pattern characterSplitPattern = compile("([a-zA-Z0-9])([\\-_.]+)([a-zA-Z0-9]*)");

  public static boolean isFriendlyName(String name) {
    if (name.contains(" ")) {
      return true;
    }

    return splitCaps(name, " ").equalsIgnoreCase(name)
        && !characterSplitPattern.matcher(name).find();
  }

  public static String makeNameFriendly(String name) {
    String friendlyName = name.trim();

    if (friendlyName.contains(" ")) {
      return friendlyName;
    }

    while (characterSplitPattern.matcher(friendlyName).find()) {
      friendlyName = characterSplitPattern.matcher(friendlyName).replaceAll("$1 $3");
    }

    friendlyName = splitCaps(friendlyName, " ");

    if (friendlyName.toUpperCase().equals(friendlyName)) {
      friendlyName = friendlyName.toLowerCase();
    }

    return StringUtils.capitalize(friendlyName);
  }

}
