/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import static java.util.stream.Collectors.toList;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorPathMustExistInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorOperationMustExistInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.OperationMustDeclareResponseBodyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.AtLeastOneSupportedSecuritySchemeRule;
import org.mule.connectivity.restconnect.internal.validation.rules.ExtensionXmlMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.BaseJavaPackageMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.GavGroupIdMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.GavArtifactIdMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.GavVersionMustBeValidRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NotSupportedSecuritySchemeRule;
import org.mule.connectivity.restconnect.internal.validation.rules.ConnectorNameMustBeFriendlyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.OperationNameMustBeFriendlyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.PagedOperationsOperationMustDeclareResponseBodyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.ParameterNameMustBeFriendlyRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoDefaultInputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoDefaultOutputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorParameterMustBePresentInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoInputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorInputMediaTypeMustBePresentInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.NoOutputMediaTypeDefinedRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorOtputMediaTypeMustBePresentInApiRule;
import org.mule.connectivity.restconnect.internal.validation.rules.DescriptorRedundantOutputDefinitionRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

public class ModelValidator {

  private static List<ValidationRule> allRules = new LinkedList<>();
  static {
    allRules.add(new DescriptorPathMustExistInApiRule());
    allRules.add(new DescriptorOperationMustExistInApiRule());
    allRules.add(new OperationMustDeclareResponseBodyRule());
    allRules.add(new AtLeastOneSupportedSecuritySchemeRule());
    allRules.add(new ExtensionXmlMustBeValidRule());
    allRules.add(new BaseJavaPackageMustBeValidRule());
    allRules.add(new GavGroupIdMustBeValidRule());
    allRules.add(new GavArtifactIdMustBeValidRule());
    allRules.add(new GavVersionMustBeValidRule());
    allRules.add(new NotSupportedSecuritySchemeRule());
    allRules.add(new ConnectorNameMustBeFriendlyRule());
    allRules.add(new OperationNameMustBeFriendlyRule());
    allRules.add(new ParameterNameMustBeFriendlyRule());
    allRules.add(new NoDefaultInputMediaTypeDefinedRule());
    allRules.add(new NoDefaultOutputMediaTypeDefinedRule());
    allRules.add(new DescriptorParameterMustBePresentInApiRule());
    allRules.add(new NoInputMediaTypeDefinedRule());
    allRules.add(new DescriptorInputMediaTypeMustBePresentInApiRule());
    allRules.add(new NoOutputMediaTypeDefinedRule());
    allRules.add(new DescriptorOtputMediaTypeMustBePresentInApiRule());
    allRules.add(new DescriptorRedundantOutputDefinitionRule());
    allRules.add(new PagedOperationsOperationMustDeclareResponseBodyRule());
  }

  private List<ValidationRule> validationRules;

  public static ModelValidator defaultModelValidator() {
    return new ModelValidator(allRules);
  }

  public ModelValidator(List<ValidationRule> rules) {
    this.validationRules = rules;
  }

  public List<ValidationResult> preValidate(APIModel apiModel, ConnectorDescriptor connectorDescriptor) {
    return validationRules
        .stream()
        .flatMap(x -> x.preValidate(connectorDescriptor, apiModel).stream())
        .collect(toList());
  }

  public List<ValidationResult> postValidate(APIModel apiModel, ConnectorDescriptor connectorDescriptor,
                                             ConnectorModel connectorModel) {
    return validationRules
        .stream()
        .flatMap(x -> x.postValidate(connectorDescriptor, apiModel, connectorModel).stream())
        .collect(toList());
  }
}
