/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import static java.util.Collections.emptyList;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.List;

public abstract class PreValidationRule extends ValidationRule {

  public PreValidationRule(String description, String summary, Level level) {
    super(description, summary, level);
  }

  @Override
  public List<ValidationResult> postValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel,
                                             ConnectorModel connectorModel) {
    return emptyList();
  }
}
