/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation;

import static java.lang.String.format;
import static java.lang.System.lineSeparator;
import static org.apache.commons.lang3.StringUtils.isNotBlank;

public class ValidationResult {

  private ValidationRule rule;
  private String location;

  public ValidationResult(ValidationRule rule, String location) {
    this.rule = rule;
    this.location = location;
  }

  public ValidationRule.Level getLevel() {
    return this.rule.getLevel();
  }

  public String getLocation() {
    return location;
  }

  @Override
  public String toString() {
    StringBuilder stringBuilder =
        new StringBuilder(format("[%s] %s", rule.getLevel().name(), rule.getDescription()));
    stringBuilder.append(lineSeparator());

    if (isNotBlank(rule.getSummary())) {
      stringBuilder
          .append(rule.getSummary())
          .append(lineSeparator());
    }

    stringBuilder
        .append("Location: ")
        .append(location);

    return stringBuilder.toString();
  }
}
