/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import static org.mule.connectivity.restconnect.internal.util.JavaUtils.removeJavaPackageUnwantedCharacters;
import static org.mule.connectivity.restconnect.internal.validation.ValidationRule.Level.ERROR;
import static org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils.removeMavenGroupUnwantedCharacters;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;

import java.util.LinkedList;
import java.util.List;

public class GavGroupIdMustBeValidRule extends PreValidationRule {

  //R007
  public GavGroupIdMustBeValidRule() {
    super("Descriptor connectorGav's groupId must ve a valid Maven groupId",
          "The groupId defined in the connector descriptor for the connectorGav must ve a valid java package name.",
          ERROR);
  }

  @Override
  public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {

    List<ValidationResult> validationResults = new LinkedList<>();

    String groupId = connectorDescriptor.getConnectorGav().getGroupId();
    String validGroupId = removeMavenGroupUnwantedCharacters(groupId);
    String validJavaPackageGroupId = removeJavaPackageUnwantedCharacters(groupId);

    if (!groupId.equalsIgnoreCase(validGroupId) || !groupId.equalsIgnoreCase(validJavaPackageGroupId)) {
      validationResults.add(getValidationError());
    }

    return validationResults;
  }

  private ValidationResult getValidationError() {
    return new ValidationResult(this, "'groupId' property declared in the connector descriptor's 'connectorGav' property");
  }
}
