/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.model;

import static org.apache.commons.lang3.StringUtils.EMPTY;

import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;
import org.mule.connectivity.restconnect.internal.connectormodel.uri.BaseUri;

import java.util.LinkedList;
import java.util.List;

public abstract class APIModel {

  protected String apiName = EMPTY;
  protected String description = EMPTY;
  protected BaseUri baseUri;
  protected List<APIOperationModel> operationsModel = new LinkedList<>();
  protected List<Protocol> protocols;

  public String getApiName() {
    return apiName;
  }

  public String getDescription() {
    return description;
  }

  public BaseUri getBaseUri() {
    return baseUri;
  }

  public List<APIOperationModel> getOperationsModel() {
    return operationsModel;
  }

  public List<Protocol> getProtocols() {
    return protocols;
  }

}
