/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.model;

import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;

import java.util.LinkedList;
import java.util.List;

public abstract class APIOperationModel {

  protected String name;
  protected String description;
  protected String path;
  protected HTTPMethod httpMethod;

  protected List<APIParameterModel> uriParamsModel;
  protected List<APIParameterModel> queryParamsModel;
  protected List<APIParameterModel> headersModel;

  protected List<APITypeModel> inputMetadataModel;
  protected List<APITypeModel> outputMetadataModel;

  protected List<APISecuritySchemeModel> securitySchemesModel;

  public String getName() {
    return name;
  }

  public String getDescription() {
    return description;
  }

  public String getPath() {
    return path;
  }

  public HTTPMethod getHttpMethod() {
    return httpMethod;
  }

  public List<APIParameterModel> getUriParamsModel() {
    return uriParamsModel;
  }

  public List<APIParameterModel> getQueryParamsModel() {
    return queryParamsModel;
  }

  public List<APIParameterModel> getHeadersModel() {
    return headersModel;
  }

  public List<APITypeModel> getInputMetadataModel() {
    return inputMetadataModel;
  }

  public List<APITypeModel> getOutputMetadataModel() {
    return outputMetadataModel;
  }

  public List<APISecuritySchemeModel> getSecuritySchemesModel() {
    return securitySchemesModel;
  }

  protected <T> List<T> selectSecuritySchemes(List<T> operationSchemes, List<T> endPointSchemes, List<T> globalSchemes) {
    //If the operation defines security, we use it.
    if (!operationSchemes.isEmpty()) {
      return operationSchemes;
    }

    //If the operation does not defines security, we try with the endpoint.
    else if (!endPointSchemes.isEmpty()) {
      return endPointSchemes;
    }

    //If the endpoint does not defines security, we try with the global config.
    else if (!globalSchemes.isEmpty()) {
      return globalSchemes;
    }

    // If the method is not secured we return an empty list.
    else {
      return new LinkedList<>();
    }
  }
}
