/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser;

import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFAPIModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPAPIModel;

import java.io.File;

public class ApiParser {

  private ApiParser() {}

  public static APIModel parseModel(File spec, SpecFormat format, Parser parser, String rootDir, boolean skipValidations)
      throws ModelGenerationException {
    return buildSpecAPIParser(parser, format, spec, rootDir, skipValidations);
  }

  private static APIModel buildSpecAPIParser(Parser parser, SpecFormat format, File apiSpec, String rootDir,
                                             boolean skipValidations)
      throws ModelGenerationException {
    if (parser.equals(Parser.RAML_PARSER)) {
      return new RPAPIModel(apiSpec, rootDir, format, skipValidations);
    } else {
      return new AMFAPIModel(apiSpec, rootDir, format, skipValidations);
    }
  }

}
