/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.amf;

import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE_TIME;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.FILE;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.INTEGER;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.NUMBER;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.STRING;
import static org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY;

import amf.client.model.domain.FileShape;
import amf.client.model.domain.ScalarShape;
import amf.client.model.domain.Shape;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition.PrimitiveType;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;

import java.util.HashMap;
import java.util.Map;

public class AMFPrimitiveTypeModel extends APIPrimitiveTypeModel {

  public AMFPrimitiveTypeModel(Shape shape) {
    this.primitiveType = getPrimitiveType(shape);
  }

  public AMFPrimitiveTypeModel(PrimitiveType primitiveTypeDefinition) {
    this.primitiveType = primitiveTypeDefinition;
  }

  private static final Map<String, PrimitiveType> scalarTypeMappings = new HashMap<>();
  static {
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#boolean", BOOLEAN);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#float", NUMBER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#double", NUMBER);
    scalarTypeMappings.put("http://a.ml/vocabularies/shapes#number", NUMBER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#integer", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#long", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#byte", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#short", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedByte", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedInt", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedLong", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#unsignedShort", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#positiveInteger", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#negativeInteger", INTEGER);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#string", STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#base64Binary", STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#hexBinary", STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#token", STRING);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#dateTime", DATE_TIME);
    scalarTypeMappings.put("http://a.ml/vocabularies/shapes#dateTimeOnly", DATE_TIME_ONLY);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#date", DATE_ONLY);
    scalarTypeMappings.put("http://www.w3.org/2001/XMLSchema#time", TIME_ONLY);
  }

  private PrimitiveType getPrimitiveType(Shape shape) {

    if (shape instanceof ScalarShape) {
      return scalarTypeMappings.get(((ScalarShape) shape).dataType().value());
    }

    else if (shape instanceof FileShape) {
      return FILE;
    }

    //Reaching this line would mean that a new type is supported in AMF but we have not implemented it in Rest Connect yet
    throw new IllegalArgumentException("Type declaration is not a primitive type.");
  }

}
