/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.webapi.model.APIPrimitiveTypeModel;

import org.raml.v2.api.model.v10.datamodel.BooleanTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTimeTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.DateTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.FileTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.IntegerTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.StringTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TimeOnlyTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RPPrimitiveTypeModel extends APIPrimitiveTypeModel {

  public RPPrimitiveTypeModel(PrimitiveTypeDefinition.PrimitiveType primitiveType) {
    this.primitiveType = primitiveType;
  }

  public RPPrimitiveTypeModel(TypeDeclaration typeDeclaration) {
    this.primitiveType = buildPrimitiveType(typeDeclaration);
  }

  private PrimitiveTypeDefinition.PrimitiveType buildPrimitiveType(TypeDeclaration typeDeclaration) {
    if (typeDeclaration instanceof BooleanTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.BOOLEAN;
    }

    else if (typeDeclaration instanceof DateTimeOnlyTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY;
    }

    else if (typeDeclaration instanceof DateTimeTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.DATE_TIME;
    }

    else if (typeDeclaration instanceof DateTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.DATE;
    }

    else if (typeDeclaration instanceof FileTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.FILE;
    }

    else if (typeDeclaration instanceof IntegerTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.INTEGER;
    }

    else if (typeDeclaration instanceof NumberTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.NUMBER;
    }

    else if (typeDeclaration instanceof StringTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.STRING;
    }

    else if (typeDeclaration instanceof TimeOnlyTypeDeclaration) {
      return PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY;
    }

    //Reaching this line would mean that a new type is supported in RAML Parser but we have not implemented it in Rest Connect yet
    throw new IllegalArgumentException("Type declaration isn't from a primitive type.");
  }
}
