/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser;

import static javax.ws.rs.core.MediaType.APPLICATION_XML_TYPE;

import java.util.function.Supplier;

import javax.ws.rs.core.MediaType;

import org.raml.v2.api.model.v10.datamodel.ExternalTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class RPTypeSchemaSupplier implements Supplier<String> {

  private TypeDeclaration typeDeclaration;
  private MediaType mediaType;

  RPTypeSchemaSupplier(TypeDeclaration typeDeclaration, MediaType mediaType) {
    this.typeDeclaration = typeDeclaration;
    this.mediaType = mediaType;
  }

  @Override
  public String get() {
    if (mediaType != null && mediaType.equals(APPLICATION_XML_TYPE)) {
      if (typeDeclaration instanceof ExternalTypeDeclaration) {
        return ((ExternalTypeDeclaration) typeDeclaration).schemaContent();
      }
      return typeDeclaration.toXmlSchema();
    } else {
      if (typeDeclaration instanceof ExternalTypeDeclaration) {
        return ((ExternalTypeDeclaration) typeDeclaration).schemaContent();
      }
      return typeDeclaration.toJsonSchema();
    }
  }
}
