/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.resourceloader;

import org.raml.v2.api.loader.FileResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;

import javax.annotation.Nullable;
import java.io.File;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;

public class RPExchangeDependencyResourceLoader implements ResourceLoader {

  private File workingDir;
  private ResourceLoader resourceLoader;

  private static final Pattern DEPENDENCY_PATH_PATTERN = Pattern.compile("^exchange_modules/|/exchange_modules/");

  public RPExchangeDependencyResourceLoader(String rootDir) {
    String basePath = rootDir != null ? rootDir : ".";
    workingDir = new File(basePath);
    resourceLoader = new FileResourceLoader(basePath);
  }

  @Nullable
  @Override
  public InputStream fetchResource(String path) {
    if (isNullOrEmpty(path)) {
      return null;
    }

    final String resourceName;

    final Matcher matcher = DEPENDENCY_PATH_PATTERN.matcher(path);
    if (matcher.find()) {

      final int dependencyIndex = path.lastIndexOf(matcher.group(0));
      resourceName = dependencyIndex <= 0 ? path : path.substring(dependencyIndex);
      return resourceLoader.fetchResource(new File(workingDir, resourceName).getAbsolutePath());

    } else {
      return null;

    }
  }
}
