/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.security;

import org.mule.connectivity.restconnect.internal.webapi.parser.security.RAMLSecuritySchemes;

public class RPSecuritySchemesNaming {

  private RPSecuritySchemesNaming() {}

  public static boolean isOauth1(String name) {
    return RAMLSecuritySchemes.OAUTH1.equalsIgnoreCase(name);
  }

  public static boolean isOauth2(String name) {
    return RAMLSecuritySchemes.OAUTH2.equalsIgnoreCase(name);
  }

  public static boolean isPassThrough(String name) {
    return RAMLSecuritySchemes.PASS_THROUGH.equalsIgnoreCase(name);
  }

  public static boolean isBasicAuth(String name) {
    return RAMLSecuritySchemes.BASIC.equalsIgnoreCase(name);
  }

  public static boolean isDigest(String name) {
    return RAMLSecuritySchemes.DIGEST_AUTHENTICATION.equalsIgnoreCase(name);
  }

  public static boolean isCustom(String name) {
    return name.toLowerCase().startsWith("x-");
  }

}
