/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.api;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.mule.connectivity.restconnect.api.DescriptorMode;
import org.mule.connectivity.restconnect.api.Parser;
import org.mule.connectivity.restconnect.api.SpecFormat;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorCategory;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorPackage;
import org.mule.connectivity.restconnect.internal.connectormodel.HTTPMethod;
import org.mule.connectivity.restconnect.internal.connectormodel.type.EmptyTypeDefinition;
import org.mule.connectivity.restconnect.internal.descriptor.model.APISpecDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.APIUrlDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.BaseUriDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.EndPointDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.MavenGavDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.OperationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PaginationDeclarationDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.PartDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.RequestDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.SecuritySchemeDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.writer.DescriptorWriter;
import org.mule.connectivity.restconnect.internal.util.NamingUtil;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIParameterModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.amf.AMFAPIModel;
import org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.RPAPIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class DescriptorScaffolder {
    private static final String DEFAULT_MVN_GROUP_ID = "com.mulesoft.connectors";
    private static final String DEFAULT_MVN_VERSION = "1.0.0";
    private static final String DESCRIPTOR_FILE_NAME = "descriptor.yaml";

    private DescriptorScaffolder() {
    }

    public static void scaffoldDescriptor(File spec, SpecFormat format, Parser parser, Path outputDir, DescriptorMode descriptorMode, boolean skipValidation) throws ModelGenerationException, IOException {
        ConnectorDescriptor connectorDescriptor = DescriptorScaffolder.scaffoldDescriptorModel(spec, format, parser, descriptorMode, skipValidation);
        DescriptorScaffolder.writeToYaml(connectorDescriptor, outputDir);
    }

    public static ConnectorDescriptor scaffoldDescriptorModel(File spec, SpecFormat format, Parser parser, DescriptorMode descriptorMode, boolean skipValidation) throws ModelGenerationException {
        APIModel apiModel = parser.equals((Object)Parser.AMF) ? new AMFAPIModel(spec, spec.getParent(), format, skipValidation) : new RPAPIModel(spec, spec.getParent(), format, skipValidation);
        return DescriptorScaffolder.generateConnectorDescriptor(spec.toPath(), apiModel, descriptorMode);
    }

    public static void writeToYaml(ConnectorDescriptor connectorDescriptor, Path outputDir) throws IOException {
        DescriptorWriter descriptorWriter = new DescriptorWriter();
        String yaml = descriptorWriter.write(connectorDescriptor);
        FileUtils.writeStringToFile((File)outputDir.resolve(DESCRIPTOR_FILE_NAME).toFile(), (String)yaml, (Charset)StandardCharsets.UTF_8);
    }

    private static ConnectorDescriptor generateConnectorDescriptor(Path specPath, APIModel apiModel, DescriptorMode descriptorMode) {
        return new ConnectorDescriptor(descriptorMode.isGenerateApiSpec() ? DescriptorScaffolder.generateAPISpec(specPath) : null, descriptorMode.isGenerateApiName() ? DescriptorScaffolder.generateApiName(apiModel) : null, descriptorMode.isGenerateDescription() ? apiModel.getDescription() : null, descriptorMode.isGenerateConnectorGav() ? DescriptorScaffolder.generateConnectorGav(apiModel) : null, descriptorMode.isGenerateBaseUri() ? DescriptorScaffolder.generateBaseUri(apiModel) : null, descriptorMode.isGenerateEndpoints() ? DescriptorScaffolder.generateEndpoints(apiModel) : Collections.EMPTY_LIST, descriptorMode.isGeneratePaginations() ? DescriptorScaffolder.generatePaginations() : Collections.EMPTY_LIST, descriptorMode.isGenerateSecurity() ? DescriptorScaffolder.generateSecurity() : Collections.EMPTY_LIST, ConnectorCategory.SELECT.toString(), descriptorMode.isGenerateDefaultPackage() ? DescriptorScaffolder.generateDefaultPackage(apiModel) : null, descriptorMode.isGenerateExtensionXml() ? XmlUtils.getXmlName(DescriptorScaffolder.generateApiName(apiModel)) : null, null, null, null, null, null);
    }

    private static String generateDefaultPackage(APIModel apiModel) {
        return ConnectorPackage.buildBasePackage(DescriptorScaffolder.generateApiName(apiModel));
    }

    private static String generateApiName(APIModel apiModel) {
        String notApiName = apiModel.getApiName().replaceAll("[\\s]+(?i)api[\\s]+", "").replaceAll("^(?i)api[\\s]+", "").replaceAll("[\\s]+(?i)api$", "");
        return NamingUtil.makeNameFriendly(notApiName);
    }

    private static List<SecuritySchemeDescriptor> generateSecurity() {
        return Collections.emptyList();
    }

    private static List<EndPointDescriptor> generateEndpoints(APIModel apiModel) {
        return apiModel.getOperationsModel().stream().map(APIOperationModel::getPath).distinct().map(x -> DescriptorScaffolder.generateEndpoint(x, apiModel)).collect(Collectors.toList());
    }

    private static EndPointDescriptor generateEndpoint(String path, APIModel apiModel) {
        return new EndPointDescriptor(path, DescriptorScaffolder.generateOperations(path, apiModel), false, null);
    }

    private static List<OperationDescriptor> generateOperations(String path, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(x -> x.getPath().equalsIgnoreCase(path)).map(DescriptorScaffolder::generateOperation).collect(Collectors.toList());
    }

    private static OperationDescriptor generateOperation(APIOperationModel operationModel) {
        return new OperationDescriptor(operationModel.getHttpMethod().name().toLowerCase(), DescriptorScaffolder.generateOperationDisplayName(operationModel), operationModel.getDescription(), DescriptorScaffolder.generateDefaultInputMediaType(operationModel), DescriptorScaffolder.generateDefaultOutputMediaType(operationModel), DescriptorScaffolder.generateRequest(operationModel), false, null, null, DescriptorScaffolder.isBodylessResponse(operationModel), DescriptorScaffolder.isBodylessResponse(operationModel), null, null, null);
    }

    private static String generateOperationDisplayName(APIOperationModel operationModel) {
        return NamingUtil.isFriendlyName(operationModel.getName()) ? operationModel.getName() : NamingUtil.makeNameFriendly(operationModel.getName());
    }

    private static Boolean isBodylessResponse(APIOperationModel operationModel) {
        boolean methodRequiresBody;
        boolean bl = methodRequiresBody = operationModel.getHttpMethod().equals((Object)HTTPMethod.GET) || operationModel.getHttpMethod().equals((Object)HTTPMethod.POST) || operationModel.getHttpMethod().equals((Object)HTTPMethod.PATCH) || operationModel.getHttpMethod().equals((Object)HTTPMethod.OPTIONS);
        if (methodRequiresBody && operationModel.getOutputMetadataModel().isEmpty()) {
            return false;
        }
        boolean emptyBody = operationModel.getOutputMetadataModel().stream().allMatch(x -> x.getTypeDefinitionClass() == null || x.getTypeDefinitionClass().equals(EmptyTypeDefinition.class));
        if (methodRequiresBody && emptyBody) {
            return false;
        }
        return null;
    }

    private static String generateDefaultInputMediaType(APIOperationModel operationModel) {
        if (!operationModel.getInputMetadataModel().isEmpty() && operationModel.getInputMetadataModel().get(0).getMediaType() != null) {
            return operationModel.getInputMetadataModel().get(0).getMediaType().toString();
        }
        return null;
    }

    private static String generateDefaultOutputMediaType(APIOperationModel operationModel) {
        if (!operationModel.getOutputMetadataModel().isEmpty() && operationModel.getOutputMetadataModel().get(0).getMediaType() != null) {
            return operationModel.getOutputMetadataModel().get(0).getMediaType().toString();
        }
        return null;
    }

    private static RequestDescriptor generateRequest(APIOperationModel operationModel) {
        return new RequestDescriptor(DescriptorScaffolder.generateParameters(operationModel.getHeadersModel()), DescriptorScaffolder.generateParameters(operationModel.getQueryParamsModel()), DescriptorScaffolder.generateParameters(operationModel.getUriParamsModel()), new LinkedList<PartDescriptor>());
    }

    private static List<ParameterDescriptor> generateParameters(List<APIParameterModel> parametersModel) {
        return parametersModel.stream().map(DescriptorScaffolder::generateParameter).collect(Collectors.toList());
    }

    private static ParameterDescriptor generateParameter(APIParameterModel parameterModel) {
        return new ParameterDescriptor(DescriptorScaffolder.generateParameterDisplayName(parameterModel), parameterModel.getExternalName(), parameterModel.getDescription(), false);
    }

    private static String generateParameterDisplayName(APIParameterModel parameterModel) {
        return NamingUtil.isFriendlyName(parameterModel.getDisplayName()) ? parameterModel.getDisplayName() : NamingUtil.makeNameFriendly(parameterModel.getDisplayName());
    }

    private static List<PaginationDeclarationDescriptor> generatePaginations() {
        return Collections.emptyList();
    }

    private static BaseUriDescriptor generateBaseUri(APIModel apiModel) {
        return new BaseUriDescriptor(apiModel.getBaseUri().getUri(), apiModel.getBaseUri().getType().getName(), Collections.emptyList());
    }

    private static MavenGavDescriptor generateConnectorGav(APIModel apiModel) {
        return new MavenGavDescriptor(DEFAULT_MVN_GROUP_ID, XmlUtils.getXmlName(apiModel.getApiName()), DEFAULT_MVN_VERSION);
    }

    private static APISpecDescriptor generateAPISpec(Path specPath) {
        return new APIUrlDescriptor(specPath.toString());
    }
}

