/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.security;

import java.util.List;
import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.connectormodel.security.ConnectorSecurityScheme;
import org.mule.connectivity.restconnect.internal.connectormodel.security.TestConnectionConfig;
import org.mule.connectivity.restconnect.internal.util.HashCodeUtil;

public abstract class OAuth2Scheme
extends ConnectorSecurityScheme {
    private final GrantType grantType;
    private final String authorizationUri;
    private final String accessTokenUri;
    private final List<String> scopes;

    public OAuth2Scheme(String displayName, GrantType grantType, String authorizationUri, String accessTokenUri, List<String> scopes, List<Parameter> queryParameters, List<Parameter> headers, TestConnectionConfig testConnectionConfig) {
        super(ConnectorSecurityScheme.SecuritySchemeType.OAUTH2, displayName, testConnectionConfig);
        this.grantType = grantType;
        this.authorizationUri = authorizationUri;
        this.accessTokenUri = accessTokenUri;
        this.scopes = scopes;
        this.queryParameters.addAll(queryParameters);
        this.headers.addAll(headers);
    }

    public String getScopes() {
        return this.getScopes(" ");
    }

    public String getScopes(String joinWith) {
        String scopesString = "";
        if (this.scopes != null) {
            scopesString = String.join((CharSequence)joinWith, this.scopes);
        }
        return scopesString;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public GrantType getGrantType() {
        return this.grantType;
    }

    @Override
    public int hashCode() {
        return HashCodeUtil.generateHashCode(new Object[]{this.schemeType, this.grantType, this.headers, this.queryParameters, this.authorizationUri, this.accessTokenUri});
    }

    public static enum GrantType {
        AUTHORIZATION_CODE("authorization_code"),
        CLIENT_CREDENTIALS("client_credentials");

        private final String type;

        private GrantType(String type) {
            this.type = type;
        }

        public String toString() {
            return this.type;
        }
    }
}

