/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.uri;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.connectormodel.Protocol;

public class BaseUri {
    private static final String VERSION_URI_PARAM_REGEX = "\\{version\\}";
    private static final String PROTOCOL_SEPARATOR = "://";
    private String uri;
    private Type type;
    private String apiVersion;
    private List<Protocol> supportedProtocols;
    private Map<String, String> uriMappings = new HashMap<String, String>();

    public BaseUri(String uri, String apiVersion, List<Protocol> supportedProtocols) {
        this(uri, Type.PARAMETER, apiVersion, supportedProtocols);
    }

    public BaseUri(String uri, Type type, String apiVersion, List<Protocol> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
        this.uri = this.addProtocolToUri(uri, supportedProtocols);
        this.type = type;
        this.apiVersion = apiVersion;
    }

    private String addProtocolToUri(String uri, List<Protocol> supportedProtocols) {
        if (uri == null) {
            return null;
        }
        if (uri.contains(PROTOCOL_SEPARATOR)) {
            return uri;
        }
        if (!supportedProtocols.isEmpty() && !supportedProtocols.contains((Object)Protocol.HTTPS)) {
            return (Object)((Object)Protocol.HTTP) + PROTOCOL_SEPARATOR + uri;
        }
        return (Object)((Object)Protocol.HTTPS) + PROTOCOL_SEPARATOR + uri;
    }

    public String getUri() {
        if (StringUtils.isNotBlank((CharSequence)this.uri)) {
            if (StringUtils.isNotBlank((CharSequence)this.apiVersion)) {
                this.uri = this.uri.replaceAll(VERSION_URI_PARAM_REGEX, this.apiVersion);
            }
            if (this.uri.endsWith("/")) {
                this.uri = this.uri.substring(0, this.uri.length() - 1);
            }
        }
        return this.uri;
    }

    public Type getType() {
        return this.type;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, String> getUriMappings() {
        return this.uriMappings;
    }

    public void addMultipleBaseUri(String uriId, String uri, boolean isDefaultUri) {
        this.uriMappings.put(uriId, uri);
        if (isDefaultUri) {
            this.uri = this.addProtocolToUri(uri, this.supportedProtocols);
        }
    }

    public String getMultipleBaseUriOrDefault(String uriId) {
        return this.uriMappings.getOrDefault(uriId, this.uri);
    }

    public boolean isMultipleBaseUri() {
        return this.type == Type.MULTIPLE;
    }

    public boolean isParameterizedBaseUri() {
        return this.type == Type.PARAMETER;
    }

    public static enum Type {
        FIXED("fixed", "Fixed base URI specified in the API Spec"),
        PARAMETER("parameter", "Parameter base URI, each instance/tenant gets its own"),
        MULTIPLE("multiple", "Multiple base URI, each operation defines its own base URI");

        private static final Map<String, Type> BY_TYPE;
        private String name;
        private String description;

        private Type(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public static Type valueOfName(String name) {
            return BY_TYPE.get(name.toLowerCase());
        }

        static {
            BY_TYPE = new HashMap<String, Type>();
            for (Type e : Type.values()) {
                BY_TYPE.put(e.getName(), e);
            }
        }
    }
}

