/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.APISpecDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.model.APIUrlDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorMavenGavParser;

public class DescriptorApiSpecParser {
    private static final String REST_CONNECT_API_SPEC = "http://a.ml/vocabularies/restConnect#webAPISpecAsset";
    private static final String REST_CONNECT_API_SPEC_URL = "http://anypoint.com/vocabs/digital-repository#webAPISpecAssetURL";
    private DescriptorMavenGavParser descriptorMavenGavParser = new DescriptorMavenGavParser();

    public APISpecDescriptor parseApiSpec(DialectDomainElement encodes) {
        DialectDomainElement apiSpecElement = this.parseApiSpecElement(encodes);
        if (apiSpecElement == null) {
            return null;
        }
        String url = this.parseUrl(apiSpecElement);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            return new APIUrlDescriptor(url);
        }
        return this.descriptorMavenGavParser.parseMavenGav(apiSpecElement);
    }

    public DialectDomainElement parseApiSpecElement(DialectDomainElement encodes) {
        List apiSpecElements = encodes.getObjectPropertyUri(REST_CONNECT_API_SPEC);
        return apiSpecElements.isEmpty() ? null : (DialectDomainElement)apiSpecElements.get(0);
    }

    public String parseUrl(DialectDomainElement apiSpecElement) {
        List groupIds = apiSpecElement.getScalarByPropertyUri(REST_CONNECT_API_SPEC_URL);
        return groupIds.isEmpty() ? null : groupIds.get(0).toString();
    }
}

