/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.descriptor.model.ParameterDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;

public class DescriptorParameterParser {
    private static final String API_CONTRACT_PARAM_NAME = "http://a.ml/vocabularies.restc/apiContract#paramName";
    private static final String REST_CONNECT_FRIENDLY_NAME = "http://a.ml/vocabularies/restConnect#friendlyName";

    public List<ParameterDescriptor> parseParameters(List<DialectDomainElement> parameterElements) {
        return parameterElements.stream().map(this::parseParameter).collect(Collectors.toList());
    }

    private ParameterDescriptor parseParameter(DialectDomainElement parameterElement) {
        return new ParameterDescriptor(this.getDisplayName(parameterElement), this.getExternalName(parameterElement), this.getDescription(parameterElement), this.getIgnored(parameterElement));
    }

    private boolean getIgnored(DialectDomainElement parameterElement) {
        return DescriptorParserUtils.parseRestConnectIgnored(parameterElement);
    }

    private String getDisplayName(DialectDomainElement parameterElement) {
        List displayNames = parameterElement.getScalarByPropertyUri(REST_CONNECT_FRIENDLY_NAME);
        return displayNames.isEmpty() ? null : displayNames.get(0).toString();
    }

    private String getExternalName(DialectDomainElement parameterElement) {
        List externalNames = parameterElement.getScalarByPropertyUri(API_CONTRACT_PARAM_NAME);
        return externalNames.isEmpty() ? null : externalNames.get(0).toString();
    }

    private String getDescription(DialectDomainElement parameterElement) {
        return DescriptorParserUtils.parseElementCoreDescription(parameterElement);
    }
}

