/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.descriptor.model.PartDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorParserUtils;

public class DescriptorPartParser {
    private static final String API_CONTRACT_PART_NAME = "http://a.ml/vocabularies.restc/apiContract#paramName";
    private static final String REST_CONNECT_FRIENDLY_NAME = "http://a.ml/vocabularies/restConnect#friendlyName";
    private static final String REST_CONNECT_INPUT_TYPE = "http://a.ml/vocabularies/restConnect#inputType";
    private static final String REST_CONNECT_INPUT_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#inputMediaType";
    private static final String REST_CONNECT_FILE_PART = "http://a.ml/vocabularies/restConnect#filePart";

    public List<PartDescriptor> parseParts(List<DialectDomainElement> parameterElements, Path descriptorFilePath) throws ModelGenerationException {
        ArrayList<PartDescriptor> parts = new ArrayList<PartDescriptor>();
        for (DialectDomainElement p : parameterElements) {
            parts.add(this.parsePart(p, descriptorFilePath));
        }
        return parts;
    }

    private PartDescriptor parsePart(DialectDomainElement partElement, Path descriptorFilePath) throws ModelGenerationException {
        return new PartDescriptor(this.getPartName(partElement), this.getFriendlyName(partElement), this.getDescription(partElement), this.getInputTypeSchema(partElement, descriptorFilePath), this.getContentType(partElement), this.getFilePart(partElement));
    }

    private String getPartName(DialectDomainElement partElement) {
        List partName = partElement.getScalarByPropertyUri(API_CONTRACT_PART_NAME);
        return partName.isEmpty() ? null : partName.get(0).toString();
    }

    private String getFriendlyName(DialectDomainElement partElement) {
        List friendlyName = partElement.getScalarByPropertyUri(REST_CONNECT_FRIENDLY_NAME);
        return friendlyName.isEmpty() ? null : friendlyName.get(0).toString();
    }

    private String getDescription(DialectDomainElement partElement) {
        return DescriptorParserUtils.parseElementCoreDescription(partElement);
    }

    private String getInputTypeSchema(DialectDomainElement partElement, Path descriptorDirectory) throws ModelGenerationException {
        List inputTypeSchema = partElement.getScalarByPropertyUri(REST_CONNECT_INPUT_TYPE);
        String inputSchemaPathString = inputTypeSchema.isEmpty() ? null : inputTypeSchema.get(0).toString();
        return DescriptorParserUtils.getSchemaContent(descriptorDirectory, inputSchemaPathString);
    }

    private String getContentType(DialectDomainElement partElement) {
        List contentType = partElement.getScalarByPropertyUri(REST_CONNECT_INPUT_MEDIA_TYPE);
        return contentType.isEmpty() ? null : contentType.get(0).toString();
    }

    private boolean getFilePart(DialectDomainElement partElement) {
        List isFile = partElement.getScalarByPropertyUri(REST_CONNECT_FILE_PART);
        return !isFile.isEmpty() && Boolean.parseBoolean(isFile.get(0).toString());
    }
}

