/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.descriptor.parser;

import amf.client.model.domain.DialectDomainElement;
import amf.core.model.domain.AmfArray;
import amf.core.model.domain.AmfElement;
import amf.core.parser.Value;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.mule.connectivity.restconnect.internal.descriptor.model.TestConnectionDescriptor;
import org.mule.connectivity.restconnect.internal.descriptor.parser.DescriptorTestConnectionResponseValidationParser;
import scala.collection.Iterator;

public class DescriptorTestConnectionParser {
    private static final String REST_CONNECT_TEST_CONNECTION = "http://a.ml/vocabularies/restConnect#testConnection";
    private static final String REST_CONNECT_TEST_CONNECTION_PATH = "http://a.ml/vocabularies/restConnect#testConnectionPath";
    private static final String REST_CONNECT_TEST_CONNECTION_METHOD = "http://a.ml/vocabularies/restConnect#testConnectionMethod";
    private static final String REST_CONNECT_TEST_CONNECTION_STATUS_CODES = "http://a.ml/vocabularies/restConnect#testConnectionValidStatusCodes";
    private static final String REST_CONNECT_TEST_CONNECTION_MEDIA_TYPE = "http://a.ml/vocabularies/restConnect#testConnectionMediaType";
    private static DescriptorTestConnectionResponseValidationParser responseValidationParser = new DescriptorTestConnectionResponseValidationParser();

    public TestConnectionDescriptor parseTestConnection(DialectDomainElement parentElement) {
        DialectDomainElement testConnectionElement = parentElement.getObjectPropertyUri(REST_CONNECT_TEST_CONNECTION).stream().findFirst().orElse(null);
        if (testConnectionElement == null) {
            return null;
        }
        return new TestConnectionDescriptor(this.getPath(testConnectionElement), this.getMethod(testConnectionElement), this.getValidStatusCodes(testConnectionElement), this.getMediaType(testConnectionElement), responseValidationParser.parseResponseValidations(testConnectionElement));
    }

    private String getPath(@NotNull DialectDomainElement testConnectionElement) {
        List paths = testConnectionElement.getScalarByPropertyUri(REST_CONNECT_TEST_CONNECTION_PATH);
        return paths.isEmpty() ? null : paths.get(0).toString();
    }

    private String getMethod(@NotNull DialectDomainElement testConnectionElement) {
        List paths = testConnectionElement.getScalarByPropertyUri(REST_CONNECT_TEST_CONNECTION_METHOD);
        return paths.isEmpty() ? null : paths.get(0).toString();
    }

    private Set<String> getValidStatusCodes(@NotNull DialectDomainElement testConnectionElement) {
        List validStatusCodes = testConnectionElement.getScalarByPropertyUri(REST_CONNECT_TEST_CONNECTION_STATUS_CODES);
        if (!validStatusCodes.isEmpty() && validStatusCodes.get(0) instanceof Value && ((Value)validStatusCodes.get(0)).value() instanceof AmfArray) {
            HashSet<String> result = new HashSet<String>();
            AmfArray amfArray = (AmfArray)((Value)validStatusCodes.get(0)).value();
            Iterator iterator = amfArray.values().iterator();
            while (iterator.hasNext()) {
                result.add(((AmfElement)iterator.next()).toString());
            }
            return result;
        }
        return Collections.emptySet();
    }

    private String getMediaType(@NotNull DialectDomainElement testConnectionElement) {
        List paths = testConnectionElement.getScalarByPropertyUri(REST_CONNECT_TEST_CONNECTION_MEDIA_TYPE);
        return paths.isEmpty() ? null : paths.get(0).toString();
    }
}

