/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import java.nio.file.Path;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.MultipartTypeDefinition;
import org.mule.connectivity.restconnect.internal.templating.sdk.AbstractSdkOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkMarkerPaginationOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkMultipartOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkOffsetPaginationOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkOperation;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkPageNumberPaginationOperation;

public class SdkOperationFactory {
    public static AbstractSdkOperation create(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation) throws TemplatingException {
        if (operation.hasPagination()) {
            String pagingType = connectorModel.getPagination(operation.getPagination()).getType();
            if ("offset".equalsIgnoreCase(pagingType)) {
                return new SdkOffsetPaginationOperation(outputDir, connectorModel, sdkConnector, operation);
            }
            if ("marker".equalsIgnoreCase(pagingType)) {
                return new SdkMarkerPaginationOperation(outputDir, connectorModel, sdkConnector, operation);
            }
            if ("pageNumber".equalsIgnoreCase(pagingType)) {
                return new SdkPageNumberPaginationOperation(outputDir, connectorModel, sdkConnector, operation);
            }
        }
        if (operation.getInputMetadata() instanceof MultipartTypeDefinition) {
            return new SdkMultipartOperation(outputDir, connectorModel, sdkConnector, operation);
        }
        return new SdkOperation(outputDir, connectorModel, sdkConnector, operation);
    }
}

