/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import java.nio.file.Path;
import javax.ws.rs.core.MediaType;
import org.mule.connectivity.restconnect.exception.TemplatingException;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorModel;
import org.mule.connectivity.restconnect.internal.connectormodel.ConnectorOperation;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.CustomTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.JsonTypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.XmlTypeSchema;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkAbstractStaticMetadataResolver;
import org.mule.connectivity.restconnect.internal.templating.sdk.SdkConnector;
import org.mule.connectivity.restconnect.internal.util.FileGenerationUtils;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.BooleanOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.DateOnlyOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.DateTimeOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.FileOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.FromJsonOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.IntegerOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.JsonOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.NumberOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.StringOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.TimeOnlyOutputMetadataResolver;
import org.mule.connectors.restconnect.commons.api.datasense.resolver.output.XmlOutputMetadataResolver;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;

public class SdkOutputMetadataResolver
extends SdkAbstractStaticMetadataResolver {
    private String qName;

    public SdkOutputMetadataResolver(Path outputDir, ConnectorModel connectorModel, SdkConnector sdkConnector, ConnectorOperation operation, TypeDefinition typeDefinition) throws TemplatingException {
        super(outputDir, connectorModel, sdkConnector, operation, typeDefinition, FileGenerationUtils.SchemaNameType.OUTPUT, "");
    }

    @Override
    protected Class<?> buildSuperclass(TypeDefinition typeDefinition) throws TemplatingException {
        TypeSchema typeSchema = typeDefinition.getTypeSchema();
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return this.getPrimitiveMetadataResolverClass((PrimitiveTypeDefinition)typeDefinition);
        }
        if (typeSchema instanceof XmlTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
            this.qName = ((XmlTypeSchema)typeDefinition.getTypeSchema()).getElementName();
            return XmlOutputMetadataResolver.class;
        }
        if (typeSchema instanceof JsonTypeSchema || typeDefinition.getMediaType().isCompatible(MediaType.APPLICATION_JSON_TYPE)) {
            return JsonOutputMetadataResolver.class;
        }
        if (typeSchema instanceof CustomTypeSchema) {
            return FromJsonOutputMetadataResolver.class;
        }
        return StringOutputMetadataResolver.class;
    }

    protected Class<?> getPrimitiveMetadataResolverClass(PrimitiveTypeDefinition primitiveTypeDefinition) throws TemplatingException {
        PrimitiveTypeDefinition.PrimitiveType primitiveType = primitiveTypeDefinition.getPrimitiveType();
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.NUMBER)) {
            return NumberOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.INTEGER)) {
            return IntegerOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.STRING)) {
            return StringOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.BOOLEAN)) {
            return BooleanOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_TIME_ONLY)) {
            return DateTimeOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.TIME_ONLY)) {
            return TimeOnlyOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE_ONLY) || primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.DATE)) {
            return DateOnlyOutputMetadataResolver.class;
        }
        if (primitiveType.equals((Object)PrimitiveTypeDefinition.PrimitiveType.FILE)) {
            return FileOutputMetadataResolver.class;
        }
        throw new TemplatingException("Primitive type not supported: " + primitiveType.name());
    }

    public AnnotationSpec getOutputMetadataResolverAnnotation() {
        return AnnotationSpec.builder(OutputResolver.class).addMember("output", "$T.class", new Object[]{ClassName.get((String)this.getPackage(), (String)this.getClassName(), (String[])new String[0])}).build();
    }

    @Override
    protected String getClassNameSuffix() {
        return "OutputMetadataResolver";
    }

    @Override
    protected boolean requiresQNameMethod() {
        return this.superclass.equals(XmlOutputMetadataResolver.class);
    }

    @Override
    protected boolean requiresFormatMethod() {
        return this.superclass.equals(FromJsonOutputMetadataResolver.class) || this.superclass.equals(FileOutputMetadataResolver.class);
    }

    @Override
    protected String getQName() {
        return this.qName;
    }

    @Override
    protected boolean requiresToWriteSchema() {
        return this.superclass.equals(FromJsonOutputMetadataResolver.class) || this.superclass.equals(JsonOutputMetadataResolver.class) || this.superclass.equals(XmlOutputMetadataResolver.class);
    }
}

