/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.templating.sdk;

import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.Date;
import org.mule.connectivity.restconnect.internal.connectormodel.type.PrimitiveTypeDefinition;
import org.mule.connectivity.restconnect.internal.connectormodel.type.TypeDefinition;

public class SdkTypeDefinitionUtils {
    private SdkTypeDefinitionUtils() {
    }

    public static Type getJavaType(TypeDefinition typeDefinition) {
        if (typeDefinition instanceof PrimitiveTypeDefinition) {
            return SdkTypeDefinitionUtils.getJavaPrimitiveType((PrimitiveTypeDefinition)typeDefinition);
        }
        return InputStream.class;
    }

    private static Type getJavaPrimitiveType(PrimitiveTypeDefinition primitiveTypeDefinition) {
        switch (primitiveTypeDefinition.getPrimitiveType()) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case NUMBER: {
                return Double.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case DATE: 
            case DATE_TIME: 
            case DATE_ONLY: 
            case DATE_TIME_ONLY: 
            case TIME_ONLY: {
                return Date.class;
            }
            case FILE: {
                return InputStream.class;
            }
            case STRING: {
                return String.class;
            }
        }
        throw new IllegalArgumentException("PrimitiveTypeDefinition not supported : " + (Object)((Object)primitiveTypeDefinition.getPrimitiveType()));
    }
}

