/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.connectivity.restconnect.internal.connectormodel.security.NotSupportedScheme;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.model.APIOperationModel;

public class AtLeastOneSupportedSecuritySchemeRule
extends PreValidationRule {
    public AtLeastOneSupportedSecuritySchemeRule() {
        super("At least one of the declared security schemes must be supported", "When the API spec declares security, at least one of the declared security schemes must be supported.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        return apiModel.getOperationsModel().stream().filter(this::allSecuritySchemesUnsupported).map(this::getValidationError).collect(Collectors.toList());
    }

    private boolean allSecuritySchemesUnsupported(APIOperationModel apiOperationModel) {
        return !apiOperationModel.getSecuritySchemesModel().isEmpty() && apiOperationModel.getSecuritySchemesModel().stream().allMatch(x -> x.getSecuritySchemeClass().equals(NotSupportedScheme.class));
    }

    private ValidationResult getValidationError(APIOperationModel apiOperationModel) {
        String location = "Operation with PATH: " + apiOperationModel.getPath() + " and METHOD: " + apiOperationModel.getHttpMethod().name();
        return new ValidationResult(this, location);
    }
}

