/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class ExtensionXmlMustBeValidRule
extends PreValidationRule {
    public ExtensionXmlMustBeValidRule() {
        super("Descriptor extensionXml property must be xml valid", "When present in the connector descriptor, extensionXml property must be a xml valid name.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String extensionXml = connectorDescriptor.getExtensionXml();
        if (StringUtils.isBlank((CharSequence)extensionXml)) {
            return validationResults;
        }
        String xmlValidExtensionXml = XmlUtils.getXmlName(extensionXml);
        if (!extensionXml.equalsIgnoreCase(xmlValidExtensionXml)) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "Descriptor extensionXml");
    }
}

