/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.validation.rules;

import java.util.LinkedList;
import java.util.List;
import org.mule.connectivity.restconnect.internal.descriptor.model.ConnectorDescriptor;
import org.mule.connectivity.restconnect.internal.validation.PreValidationRule;
import org.mule.connectivity.restconnect.internal.validation.ValidationResult;
import org.mule.connectivity.restconnect.internal.validation.ValidationRule;
import org.mule.connectivity.restconnect.internal.webapi.model.APIModel;
import org.mule.connectivity.restconnect.internal.webapi.util.XmlUtils;

public class GavArtifactIdMustBeValidRule
extends PreValidationRule {
    public GavArtifactIdMustBeValidRule() {
        super("Descriptor connectorGav's artifactId must ve a valid Maven artifactId", "The artifactId defined in the connector descriptor for the connectorGav can contain lowercase letters and no strange symbols.", ValidationRule.Level.ERROR);
    }

    @Override
    public List<ValidationResult> preValidate(ConnectorDescriptor connectorDescriptor, APIModel apiModel) {
        String validArtifactId;
        LinkedList<ValidationResult> validationResults = new LinkedList<ValidationResult>();
        String artifactId = connectorDescriptor.getConnectorGav().getArtifactId();
        if (!artifactId.equalsIgnoreCase(validArtifactId = XmlUtils.removeMavenArtifactUnwantedCharacters(artifactId))) {
            validationResults.add(this.getValidationError());
        }
        return validationResults;
    }

    private ValidationResult getValidationError() {
        return new ValidationResult(this, "'artifactId' property declared in the connector descriptor's 'connectorGav' property");
    }
}

