/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.mule.connectivity.restconnect.exception.ModelGenerationException;
import org.mule.connectivity.restconnect.internal.connectormodel.type.schema.TypeSchema;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;

public class TypeSchemaPool {
    private Map<String, TypeSchema> innerJsonPool;
    private Map<String, TypeSchema> innerSchemaPool;
    private ObjectMapper mapper = new ObjectMapper();

    public TypeSchemaPool() {
        this.reset();
    }

    public boolean containsTypeSchema(String rawSchema) {
        if (this.isJsonSchema(rawSchema)) {
            return this.innerJsonPool.keySet().stream().anyMatch(x -> this.isEqualJsonSchema((String)x, rawSchema));
        }
        return this.innerSchemaPool.keySet().stream().anyMatch(x -> x.equalsIgnoreCase(rawSchema));
    }

    private boolean isJsonSchema(String rawSchema) {
        try {
            this.mapper.readTree(rawSchema);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private boolean isEqualJsonSchema(String schemaA, String schemaB) {
        JSONCompareResult jsonCompareResult = JSONCompare.compareJSON((String)schemaA, (String)schemaB, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
        return !jsonCompareResult.failed();
    }

    public TypeSchema getTypeSchema(String rawSchema) throws ModelGenerationException {
        TypeSchema typeSchema;
        if (this.isJsonSchema(rawSchema)) {
            String first = this.innerJsonPool.keySet().stream().filter(x -> this.isEqualJsonSchema((String)x, rawSchema)).findFirst().orElse(null);
            typeSchema = this.innerJsonPool.get(first);
        } else {
            typeSchema = this.innerSchemaPool.get(rawSchema);
        }
        if (typeSchema == null) {
            throw new ModelGenerationException("This typeSchemaPool does not contain a type definition for the specified typeSchema");
        }
        return typeSchema;
    }

    public void putTypeSchema(String schema, TypeSchema typeSchema) throws ModelGenerationException {
        if (this.containsTypeSchema(schema)) {
            throw new ModelGenerationException("TypeSchema already exists in typeSchemaPool");
        }
        if (this.isJsonSchema(schema)) {
            this.innerJsonPool.put(schema, typeSchema);
        } else {
            this.innerSchemaPool.put(schema, typeSchema);
        }
    }

    public void reset() {
        this.innerJsonPool = new HashMap<String, TypeSchema>();
        this.innerSchemaPool = new HashMap<String, TypeSchema>();
    }
}

