/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectivity.restconnect.internal.webapi.parser.ramlparser.util;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.methods.Method;
import org.raml.v2.api.model.v10.resources.Resource;

public class RPOperationMappingUtils {
    private RPOperationMappingUtils() {
    }

    public static List<Method> getMethods(Api api) {
        return RPOperationMappingUtils.getAllResources(api).stream().flatMap(x -> x.methods().stream()).collect(Collectors.toList());
    }

    private static List<Resource> getAllResources(Api api) {
        LinkedList<Resource> allResources = new LinkedList<Resource>(api.resources());
        for (Resource resource : api.resources()) {
            allResources.addAll(RPOperationMappingUtils.getSubResources(resource));
        }
        return allResources;
    }

    private static List<Resource> getSubResources(Resource resource) {
        LinkedList<Resource> subResources = new LinkedList<Resource>(resource.resources());
        for (Resource r : resource.resources()) {
            subResources.addAll(RPOperationMappingUtils.getSubResources(r));
        }
        return subResources;
    }
}

