/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.connectormodel.security;

import org.mule.connectivity.restconnect.internal.connectormodel.parameter.Parameter;
import org.mule.connectivity.restconnect.internal.util.HashCodeUtil;

import java.util.List;

import org.apache.commons.lang3.StringUtils;

public abstract class OAuth2Scheme extends APISecurityScheme {

  public enum GrantType {
    AUTHORIZATION_CODE("authorization_code"), CLIENT_CREDENTIALS("client_credentials");

    private final String type;

    GrantType(String type) {
      this.type = type;
    }

    @Override
    public String toString() {
      return this.type;
    }
  }

  private final GrantType grantType;
  private final String authorizationUri;
  private final String accessTokenUri;
  private final List<String> scopes;

  public OAuth2Scheme(String displayName, GrantType grantType, String authorizationUri, String accessTokenUri,
                      List<String> scopes, List<Parameter> queryParameters, List<Parameter> headers) {
    super(SecuritySchemeType.OAUTH2, displayName);
    this.grantType = grantType;
    this.authorizationUri = authorizationUri;
    this.accessTokenUri = accessTokenUri;
    this.scopes = scopes;
    this.queryParameters.addAll(queryParameters);
    this.headers.addAll(headers);
  }

  public String getScopes() {
    return getScopes(", ");
  }

  public String getScopes(String joinWith) {
    String scopesString = StringUtils.EMPTY;
    if (scopes != null) {
      scopesString = String.join(joinWith, scopes);
    }
    return scopesString;
  }

  public String getAccessTokenUri() {
    return accessTokenUri;
  }

  public String getAuthorizationUri() {
    return authorizationUri;
  }

  public GrantType getGrantType() {
    return grantType;
  }

  @Override
  public int hashCode() {
    return HashCodeUtil.generateHashCode(schemeType, grantType, configParameters, headers, queryParameters, authorizationUri,
                                         accessTokenUri);
  }
}
