/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.connectivity.restconnect.internal.descriptor.model;

import java.util.List;

public class ConnectorDescriptor extends DescriptorElement {

  private APISpecDescriptor apiSpec;
  private String connectorName;
  private String connectorDescription;
  private MavenGavDescriptor connectorGav;
  private BaseUriDescriptor baseUri;
  private List<PaginationDeclarationDescriptor> paginations;
  private List<EndPointDescriptor> endpoints;
  private List<SecuritySchemeDescriptor> security;
  private String connectorCategory;
  private String javaPackage;
  private String extensionXml;
  private Boolean skipOutputTypeValidation;

  public ConnectorDescriptor(APISpecDescriptor apiSpec, String connectorName, String connectorDescription,
                             MavenGavDescriptor connectorGav, BaseUriDescriptor baseUri,
                             List<EndPointDescriptor> endpoints,
                             List<PaginationDeclarationDescriptor> paginations,
                             List<SecuritySchemeDescriptor> security,
                             String connectorCategory,
                             String javaPackage,
                             String extensionXml,
                             Boolean skipOutputTypeValidation) {

    this.apiSpec = apiSpec;
    this.connectorName = connectorName;
    this.connectorDescription = connectorDescription;
    this.connectorGav = connectorGav;
    this.baseUri = baseUri;
    this.paginations = paginations;
    this.endpoints = endpoints;
    this.security = security;
    this.connectorCategory = connectorCategory;
    this.javaPackage = javaPackage;
    this.extensionXml = extensionXml;
    this.skipOutputTypeValidation = skipOutputTypeValidation;
  }

  public APISpecDescriptor getApiSpec() {
    return apiSpec;
  }

  public String getConnectorName() {
    return connectorName;
  }

  public String getConnectorDescription() {
    return connectorDescription;
  }

  public MavenGavDescriptor getConnectorGav() {
    return connectorGav;
  }

  public BaseUriDescriptor getBaseUri() {
    return baseUri;
  }

  public List<PaginationDeclarationDescriptor> getPaginations() {
    return paginations;
  }

  public List<EndPointDescriptor> getEndpoints() {
    return endpoints;
  }

  public List<SecuritySchemeDescriptor> getSecurity() {
    return security;
  }

  public String getConnectorCategory() {
    return connectorCategory;
  }

  public String getJavaPackage() {
    return javaPackage;
  }

  public String getExtensionXml() {
    return extensionXml;
  }

  public Boolean getSkipOutputTypeValidation() {
    return skipOutputTypeValidation;
  }
}
